float4x4 g_view_projection_matrix;
float4x4 g_world_matrix;
float4	g_light;
float4	g_camera_eye_vector;
float4	gLightDirColor;
float4	g_diffuse_mtrl;
float4	g_ambient_mtrl;
float4	g_supercolor;
texture g_tex0;

sampler2D tex0 : TEXUNIT0 = sampler_state
{
     Texture = (g_tex0);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
};

struct OutputVS
{
	float4 posH : POSITION;
	float2 UV : TEXCOORD0;
	float3 Light : TEXCOORD1;
	float3 Norm : TEXCOORD2;
	float3 View : TEXCOORD3;
};

OutputVS SpecularVS(float4 posL : POSITION, float3 normal : NORMAL, float2 UV : TEXCOORD0)
{
	OutputVS outVS = (OutputVS)0;
	
	outVS.posH = mul(posL, g_world_matrix);
	outVS.posH = mul(outVS.posH, g_view_projection_matrix);
	
	outVS.UV = UV;
	
	outVS.Light = g_light;
	
	outVS.Norm = mul(normal, g_world_matrix);
	
	float4 posWorld = mul(posL, g_world_matrix);
	
	outVS.View = g_camera_eye_vector - posWorld;
	
	return outVS;
}

float4 SpecularPS( float2 UV : TEXCOORD0, float3 Light : TEXCOORD1, float3 Norm : TEXCOORD2,
			float3 View : TEXCOORD3) : COLOR
{
	Norm	= normalize(Norm);
	Light	= normalize(Light);
	View	= normalize(View);
	
	//Calculate diffuse color amount
	float Diff = saturate(dot(Norm, Light));
	
	//R = 2 * (N.L) * N - L
	float3 Reflect = normalize(2 * Diff * Norm - Light);
	
	// R.V^n
	float Specular = pow(saturate(dot(Reflect, View)), 8);
	
	gLightDirColor = 1.0f;
	
	float4 textureColor = tex2D( tex0 , UV );
	
	//I = Dcolor * Dintensity * N.L + Scolor * Sintensity + (R.V)^2
	return textureColor + g_supercolor * gLightDirColor * Diff + g_diffuse_mtrl * Specular * 0.5f;
}

technique Basic
{
	pass p0
	{
		vertexShader = compile vs_2_0 SpecularVS();
		pixelShader = compile ps_2_0 SpecularPS();
	}
}

////////////////////////////////////////////////////////////////////
OutputVS NormalVS(float4 posL : POSITION, float3 normal : NORMAL, float2 UV : TEXCOORD0)
{
	OutputVS outVS = (OutputVS)0;
	
	outVS.posH = mul(posL, g_world_matrix);
	outVS.posH = mul(outVS.posH, g_view_projection_matrix);
	
	outVS.UV = UV;
	
	outVS.Light = g_light;
	
	outVS.Norm = mul(normal, g_world_matrix);
	
	float4 posWorld = mul(posL, g_world_matrix);
	
	outVS.View = g_camera_eye_vector - posWorld;
	
	return outVS;
}

float4 NormalPS( float2 UV : TEXCOORD0, float3 Light : TEXCOORD1, float3 Norm : TEXCOORD2,
			float3 View : TEXCOORD3) : COLOR
{
	float Diff = saturate( dot( normalize( Norm ) , normalize( Light ) ) );
	
	float4 textureColor = tex2D( tex0 , UV );
	
	return textureColor + ( ( g_ambient_mtrl * 0.1f ) + ( Diff * g_diffuse_mtrl * 0.5f ) );
}

technique BasicENV
{
	pass p0
	{
		vertexShader = compile vs_2_0 NormalVS();
		pixelShader = compile ps_2_0 NormalPS();
	}
}